package ru.yandex.direct.core.aggregatedstatuses.logic.Status.Campaign;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Active.ActiveCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.BlGenerated.BlGeneratedCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Ok.OkCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Processing.ProcessingCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Stopped.StoppedCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Suspended.SuspendedCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.TotalCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.Conditions;
import ru.yandex.direct.core.aggregatedstatuses.logic.States.CampaignStates;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.Status;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.StatusReasons.Campaign.CampaignProcessingReasons;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.StatusReasons.ComposedReasons;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum;
import ru.yandex.direct.core.entity.aggregatedstatuses.SelfStatus;

@ParametersAreNonnullByDefault
public final class StopProcessing implements Status {
    private final CampaignStates campaignStates;
    private final Conditions campaignConditions;
    private final TotalCounter totalCounter;
    private final ActiveCounter adGroupsActiveCounter;
    private final OkCounter adGroupsOkCounter;
    private final ProcessingCounter adGroupsProcessingCounter;
    private final BlGeneratedCounter adGroupsBlGeneratedCounter;
    private final StoppedCounter adGroupsStoppedCounter;
    private final SuspendedCounter adGroupsSuspendedCounter;

    public StopProcessing(CampaignStates campaignStates,
                          Conditions campaignConditions,
                          TotalCounter totalCounter,
                          ActiveCounter adGroupsActiveCounter,
                          OkCounter adGroupsOkCounter,
                          ProcessingCounter adGroupsProcessingCounter,
                          BlGeneratedCounter adGroupsBlGeneratedCounter,
                          StoppedCounter adGroupsStoppedCounter,
                          SuspendedCounter adGroupsSuspendedCounter) {
        this.campaignStates = campaignStates;
        this.campaignConditions = campaignConditions;
        this.totalCounter = totalCounter;
        this.adGroupsActiveCounter = adGroupsActiveCounter;
        this.adGroupsOkCounter = adGroupsOkCounter;
        this.adGroupsProcessingCounter = adGroupsProcessingCounter;
        this.adGroupsBlGeneratedCounter = adGroupsBlGeneratedCounter;
        this.adGroupsStoppedCounter = adGroupsStoppedCounter;
        this.adGroupsSuspendedCounter = adGroupsSuspendedCounter;
    }

    @Override
    public boolean isValid() {
        // Если нет групп, то это DRAFT
        if (totalCounter.adGroups() < 1) {
            return false;
        }

        if (campaignConditions.archivedCondition().isArchived() || campaignConditions.draftOrSuspendedCondition().isAllDraftOrSuspended()) {
            return false;
        }

        return !campaignStates.isSuspended() // Если кампания остановлена то это STOP_OK или STOP_WARN
                && !adGroupsActiveCounter.hasActive()
                && !campaignConditions.moderationCondition().isFullOnModeration()
                && adGroupsOkCounter.isAllOk()
                && !adGroupsSuspendedCounter.isAllSuspended(); // Если все остановлены, то это статус STOP_OK
    }

    @Override
    public SelfStatus selfStatus() {
        final var reasons = new ComposedReasons(List.of(
                new CampaignProcessingReasons(campaignConditions.moderationCondition(),
                        adGroupsProcessingCounter,
                        adGroupsBlGeneratedCounter,
                        adGroupsStoppedCounter,
                        adGroupsActiveCounter)
        )).reasons();

        return SelfStatus.status(GdSelfStatusEnum.STOP_PROCESSING, new ArrayList<>(reasons));
    }
}
