package ru.yandex.direct.core.aggregatedstatuses.logic.Status.Campaign;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.aggregatedstatuses.logic.States.CampaignStates;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.Status;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusReason;
import ru.yandex.direct.core.entity.aggregatedstatuses.SelfStatus;

@ParametersAreNonnullByDefault
public final class StopWarn implements Status {
    private final CampaignStates campaignStates;

    public StopWarn(CampaignStates campaignState) {
        this.campaignStates = campaignState;
    }

    @Override
    public boolean isValid() {
        return campaignStates.isSuspended() && campaignStates.isUnarchiving();
    }

    @Override
    public SelfStatus selfStatus() {
        return SelfStatus.status(GdSelfStatusEnum.STOP_WARN, GdSelfStatusReason.CAMPAIGN_UNARCHIVING_IN_PROGRESS);
    }
}
