package ru.yandex.direct.core.aggregatedstatuses.logic.Status.StatusReasons.AdGroup;

import java.util.HashSet;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.DraftOnModeration.DraftOnModerationCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Moderation.ModerationCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Runnable.RunnableCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.Moderation.ModerationCondition;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.StatusReasons.StatusReasons;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusReason;

@ParametersAreNonnullByDefault
public final class AdGroupModerationReasons implements StatusReasons {
    private final ModerationCondition showConditionsModerationCondition;
    private final RunnableCounter adsRunnableCounter;
    private final DraftOnModerationCounter adsDraftOnModerationCounter;
    private final ModerationCounter adsModerationCounter;

    public AdGroupModerationReasons(ModerationCondition showConditionsModerationCondition,
                                    RunnableCounter adsRunnableCounter,
                                    DraftOnModerationCounter adsDraftOnModerationCounter,
                                    ModerationCounter adsModerationCounter) {
        this.showConditionsModerationCondition = showConditionsModerationCondition;
        this.adsRunnableCounter = adsRunnableCounter;
        this.adsDraftOnModerationCounter = adsDraftOnModerationCounter;
        this.adsModerationCounter = adsModerationCounter;
    }

    @Override
    public Set<GdSelfStatusReason> reasons() {
        final var result = new HashSet<GdSelfStatusReason>();

        if (adsDraftOnModerationCounter.isAllDraftOnModeration() || adsModerationCounter.isAllOnModeration()) {
            result.add(GdSelfStatusReason.ADGROUP_ADS_ON_MODERATION);
        } else if (adsDraftOnModerationCounter.hasDraftOnModeration() || adsModerationCounter.hasOnModeration()) {
            result.add(GdSelfStatusReason.ADGROUP_HAS_ADS_ON_MODERATION);
        }

        if (!adsRunnableCounter.hasRunnable()) {
            return result;
        }

        if (showConditionsModerationCondition.isPartlyOnModeration()) {
            result.add(GdSelfStatusReason.ADGROUP_SHOW_CONDITIONS_PARTLY_ON_MODERATION);
        } else if (showConditionsModerationCondition.isFullOnModeration()) {
            result.add(GdSelfStatusReason.ADGROUP_SHOW_CONDITIONS_ON_MODERATION);
        }

        return result;
    }
}
