package ru.yandex.direct.core.aggregatedstatuses.logic.Status.StatusReasons.AdGroup;

import java.util.HashSet;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Rejected.RejectedCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Runnable.RunnableCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.States.AdGroupStates;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.StatusReasons.StatusReasons;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusReason;

@ParametersAreNonnullByDefault
public final class AdGroupRejectedReasons implements StatusReasons {
    private final AdGroupStates adGroupStates;
    private final RunnableCounter adsRunnableCounter;
    private final RejectedCounter adsRejectedCounter;

    public AdGroupRejectedReasons(AdGroupStates adGroupsStates,
                                  RunnableCounter adsRunnableCounter,
                                  RejectedCounter adsRejectedCounter) {
        this.adGroupStates = adGroupsStates;
        this.adsRunnableCounter = adsRunnableCounter;
        this.adsRejectedCounter = adsRejectedCounter;
    }

    @Override
    public Set<GdSelfStatusReason> reasons() {
        final var result = new HashSet<GdSelfStatusReason>();

        if (adsRunnableCounter.hasRunnable() && adGroupStates.isRejected()) {
            result.add(GdSelfStatusReason.ADGROUP_REJECTED_ON_MODERATION);
        }

        if (adsRejectedCounter.isAllRejected()) {
            result.add(GdSelfStatusReason.ADGROUP_ADS_REJECTED_ON_MODERATION);
        }

        return result;
    }
}
