package ru.yandex.direct.core.aggregatedstatuses.logic.Status.StatusReasons.Campaign;

import java.util.HashSet;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.Moderation.ModerationCondition;
import ru.yandex.direct.core.aggregatedstatuses.logic.States.CampaignStates;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.StatusReasons.CpmReason;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.StatusReasons.StatusReasons;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusReason;

@ParametersAreNonnullByDefault
public final class CampaignCpmReasons implements StatusReasons {
    private final CampaignStates campaignStates;
    private final ModerationCondition campaignModerationCondition;

    public CampaignCpmReasons(ModerationCondition campaignModerationCondition, CampaignStates campaignStates) {
        this.campaignStates = campaignStates;
        this.campaignModerationCondition = campaignModerationCondition;
    }

    @Override
    public Set<GdSelfStatusReason> reasons() {
        final var result = new HashSet<GdSelfStatusReason>();
        final var cpmReason = new CpmReason(campaignStates).reason();

        if (campaignModerationCondition.isFullOnModeration()) {
            cpmReason.ifPresent(result::add);
        } else if (cpmReason.isPresent() && (!campaignStates.isCpmPriceWaitingToApprove() || campaignStates.isDraftApproveAllowed())) {
            result.add(cpmReason.get());
        }

        return result;
    }
}
