package ru.yandex.direct.core.aggregatedstatuses.logic.Status.StatusReasons.Campaign;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.Moderation.ModerationCondition;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.StatusReasons.StatusReasons;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusReason;

@ParametersAreNonnullByDefault
public final class CampaignModerationReasons implements StatusReasons {
    private final ModerationCondition campaignModerationCondition;

    public CampaignModerationReasons(ModerationCondition campaignModerationCondition) {
        this.campaignModerationCondition = campaignModerationCondition;
    }

    @Override
    public Set<GdSelfStatusReason> reasons() {
        if (campaignModerationCondition.isPartlyOnModeration()) {
            return Set.of(GdSelfStatusReason.CAMPAIGN_PARTLY_ON_MODERATION);
        }

        if (campaignModerationCondition.isFullOnModeration()) {
            return Set.of(GdSelfStatusReason.CAMPAIGN_ON_MODERATION);
        }

        return Set.of();
    }
}
