package ru.yandex.direct.core.aggregatedstatuses.logic.Status.StatusReasons.Campaign;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Active.ActiveCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.States.CampaignStates;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.StatusReasons.StatusReasons;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusReason;

@ParametersAreNonnullByDefault
public final class CampaignMoneyReasons implements StatusReasons {
    private final CampaignStates campaignStates;
    private final ActiveCounter adGroupsActiveCounter;

    public CampaignMoneyReasons(CampaignStates campaignStates, ActiveCounter adGroupsActiveCounter) {
        this.campaignStates = campaignStates;
        this.adGroupsActiveCounter = adGroupsActiveCounter;
    }

    @Override
    public Set<GdSelfStatusReason> reasons() {
        // Если нет активных, то это STOP_CRIT, STOP_PROCESSING, DRAFT
        if (!campaignStates.noMoney() || !adGroupsActiveCounter.hasActive()) {
            return Set.of();
        }

        final var needMoneyReason = campaignStates.hasWallet()
                ? GdSelfStatusReason.CAMPAIGN_ADD_MONEY_TO_WALLET
                : GdSelfStatusReason.CAMPAIGN_ADD_MONEY;


        final var reason = campaignStates.awaitPayment()
                ? GdSelfStatusReason.CAMPAIGN_WAIT_PAYMENT
                : needMoneyReason;

        return Set.of(reason);
    }
}
