package ru.yandex.direct.core.aggregatedstatuses.logic.Status.StatusReasons.Campaign;

import java.util.HashSet;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Active.ActiveCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.BlGenerated.BlGeneratedCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Processing.ProcessingCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.AdvancedCounters.Stopped.StoppedCounter;
import ru.yandex.direct.core.aggregatedstatuses.logic.Conditions.Moderation.ModerationCondition;
import ru.yandex.direct.core.aggregatedstatuses.logic.Status.StatusReasons.StatusReasons;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusReason;

@ParametersAreNonnullByDefault
public final class CampaignProcessingReasons implements StatusReasons {
    private final ModerationCondition campaignModerationCondition;
    private final ProcessingCounter adGroupsProcessingCounter;
    private final BlGeneratedCounter adGroupsBlGeneratedCounter;
    private final StoppedCounter adGroupsStoppedCounter;
    private final ActiveCounter adGroupsActiveCounter;

    public CampaignProcessingReasons(ModerationCondition campaignModerationCondition,
                                     ProcessingCounter adGroupsProcessingCounter,
                                     BlGeneratedCounter adGroupsBlGeneratedCounter,
                                     StoppedCounter adGroupsStoppedCounter,
                                     ActiveCounter adGroupsActiveCounter) {
        this.campaignModerationCondition = campaignModerationCondition;
        this.adGroupsProcessingCounter = adGroupsProcessingCounter;
        this.adGroupsBlGeneratedCounter = adGroupsBlGeneratedCounter;
        this.adGroupsStoppedCounter = adGroupsStoppedCounter;
        this.adGroupsActiveCounter = adGroupsActiveCounter;
    }

    @Override
    public Set<GdSelfStatusReason> reasons() {
        if (campaignModerationCondition.isFullOnModeration()) {
            return Set.of();
        }

        final var result = new HashSet<GdSelfStatusReason>();
        final var allStoppedByBlProcessing = adGroupsBlGeneratedCounter.hasBlGeneratedProcessing()
                && adGroupsBlGeneratedCounter.blGeneratedProcessing() == adGroupsStoppedCounter.stopProcessing();

        final var allStoppedByNothingGenerated = adGroupsBlGeneratedCounter.hasBlNothingGenerated()
                && adGroupsBlGeneratedCounter.blNothingGenerated() == adGroupsStoppedCounter.stopCrit();

        final var noHasActiveAndHasProcessing = !adGroupsActiveCounter.hasActive()
                && adGroupsProcessingCounter.hasProcessing();

        if (noHasActiveAndHasProcessing && allStoppedByBlProcessing) {
            result.add(GdSelfStatusReason.CAMPAIGN_BL_PROCESSING);
        } else if (noHasActiveAndHasProcessing) {
            result.add(GdSelfStatusReason.CAMPAIGN_HAS_PROCESSING_ADGROUPS);
        }

        if (noHasActiveAndHasProcessing && !adGroupsProcessingCounter.isAllProcessing()) {
            result.add(GdSelfStatusReason.CAMPAIGN_HAS_INACTIVE_BANNERS);
        }

        final var noHasActiveAndProcessing = !adGroupsActiveCounter.hasActive()
                && !adGroupsProcessingCounter.hasProcessing();

        if (noHasActiveAndProcessing && allStoppedByNothingGenerated) {
            result.add(GdSelfStatusReason.CAMPAIGN_BL_NOTHING_GENERATED);
        } else if (noHasActiveAndProcessing) {
            result.add(GdSelfStatusReason.CAMPAIGN_HAS_NO_ADS_ELIGIBLE_FOR_SERVING);
        }

        return result;
    }
}
