package ru.yandex.direct.core.aggregatedstatuses.logic.Status.StatusReasons;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusReason;

@ParametersAreNonnullByDefault
public final class ComposedReasons implements StatusReasons {
    private final Collection<StatusReasons> statusReasons;

    public ComposedReasons(Collection<StatusReasons> statusReasons) {
        this.statusReasons = statusReasons;
    }

    @Override
    public Set<GdSelfStatusReason> reasons() {
        return statusReasons.stream().flatMap(s -> s.reasons().stream()).collect(Collectors.toSet());
    }
}
