package ru.yandex.direct.core.aggregatedstatuses.logic.Status.StatusReasons;

import java.util.Optional;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.aggregatedstatuses.logic.States.CampaignStates;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusReason;

@ParametersAreNonnullByDefault
public final class CpmReason {
    private final CampaignStates states;

    public CpmReason(CampaignStates states) {
        this.states = states;
    }

    public Optional<GdSelfStatusReason> reason() {
        if (states.isCpmPriceWaitingToApprove()) {
            return Optional.of(GdSelfStatusReason.CPM_PRICE_WAITING_FOR_APPROVE);
        } else if (states.isCpmPriceIncorrect()) {
            return Optional.of(GdSelfStatusReason.CPM_PRICE_INCORRECT);
        } else if (states.isCpmPriceNotApproved()) {
            return Optional.of(GdSelfStatusReason.CPM_PRICE_NOT_APPROVED);
        }

        return Optional.empty();
    }
}
