package ru.yandex.direct.core.aggregatedstatuses.logic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusEnum;
import ru.yandex.direct.core.entity.aggregatedstatuses.GdSelfStatusReason;
import ru.yandex.direct.core.entity.aggregatedstatuses.SelfStatus;

import static ru.yandex.direct.core.entity.aggregatedstatuses.SelfStatus.status;

public class StatusUtils {
    private StatusUtils() {
    }

    static SelfStatus mergeStatuses(SelfStatus subject, SelfStatus parent) {
        // DRAFT-ом родителя не маскируем STOP-ы (и все что выше) его подъобъектов
        boolean isParentDraft = GdSelfStatusEnum.DRAFT.equals(parent.getStatus())
                && subject.getStatus().ordinal() >= GdSelfStatusEnum.STOP_OK.ordinal();
        if (isParentDraft || subject.getStatus().ordinal() > parent.getStatus().ordinal()) {
            // показываем статус подобъекта
            return GdSelfStatusEnum.DRAFT.equals(subject.getStatus())
                    ? subject // DIRECT-122020
                    : SelfStatus.copyAddRejectReasons(addMeaningfulReasons(subject.getStatus(), subject.getReasons(),
                        parent.getReasons()), subject.getRejectReasons());
        } else {
            // показываем статус объекта верхнего уровня
            return SelfStatus.copyAddRejectReasons(addMeaningfulReasons(parent.getStatus(), parent.getReasons(),
                    subject.getReasons()), subject.getRejectReasons());
        }
    }

    static SelfStatus addMeaningfulReasons(GdSelfStatusEnum status, GdSelfStatusReason reason,
                                           List<GdSelfStatusReason> reasonsToAdd) {
        return addMeaningfulReasons(status, Collections.singletonList(reason), reasonsToAdd);
    }

    static SelfStatus addMeaningfulReasons(GdSelfStatusEnum status, List<GdSelfStatusReason> left,
                                           List<GdSelfStatusReason> right) {
        List<GdSelfStatusReason> allReasons = new ArrayList<>(left);
        List<GdSelfStatusReason> rightFiltered = filterMeaninglessReasons(right);
        allReasons.addAll(rightFiltered);
        return allReasons.size() > 1
                ? status(status, filterMeaninglessReasons(allReasons))
                : status(status, allReasons);
    }

    static List<GdSelfStatusReason> filterMeaninglessReasons(Collection<GdSelfStatusReason> reasons) {
        return reasons == null ? Collections.emptyList()
                : reasons.stream()
                    .filter(r -> !GdSelfStatusReason.isMeaningless(r))
                    .distinct()
                    .collect(Collectors.toList());
    }

    static int sumStatuses(Collection<GdSelfStatusEnum> statuses, Map<GdSelfStatusEnum, Integer> counters) {
        return statuses.stream().map(st -> counters.getOrDefault(st, 0)).reduce(0, Integer::sum);
    }
}
