package ru.yandex.direct.core.aggregatedstatuses.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.client.model.Client;
import ru.yandex.direct.core.entity.client.model.ClientFlags;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.read.JooqReaderWithSupplier;
import ru.yandex.direct.jooqmapper.read.JooqReaderWithSupplierBuilder;

import static ru.yandex.direct.common.jooqmapperex.read.ReaderBuildersEx.fromYesNoEnumFieldToBoolean;
import static ru.yandex.direct.dbschema.ppc.tables.ClientsOptions.CLIENTS_OPTIONS;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromSet;

@Repository
@ParametersAreNonnullByDefault
public class AggregatedStatusesClientRepository {
    private final DslContextProvider ppcDslContextProvider;
    private final Collection<Field<?>> fields;
    private final JooqReaderWithSupplier<Client> reader;

    @Autowired
    public AggregatedStatusesClientRepository(DslContextProvider ppcDslContextProvider) {
        this.ppcDslContextProvider = ppcDslContextProvider;
        reader = JooqReaderWithSupplierBuilder.builder(Client::new)
                .readProperty(Client.CLIENT_ID, fromField(CLIENTS_OPTIONS.CLIENT_ID))
                .readProperty(Client.DEBT, fromField(CLIENTS_OPTIONS.DEBT))
                .readProperty(Client.STATUS_BALANCE_BANNED,
                        fromYesNoEnumFieldToBoolean(CLIENTS_OPTIONS.STATUS_BALANCE_BANNED))
                .readProperty(Client.OVERDRAFT_LIMIT, fromField(CLIENTS_OPTIONS.OVERDRAFT_LIM))
                .readProperty(Client.AUTO_OVERDRAFT_LIMIT, fromField(CLIENTS_OPTIONS.AUTO_OVERDRAFT_LIM))
                .readProperty(Client.CAN_PAY_BEFORE_MODERATION,
                        fromSet(CLIENTS_OPTIONS.CLIENT_FLAGS, ClientFlags.CAN_PAY_BEFORE_MODERATION.getTypedValue()))
                .build();

        fields = reader.getFieldsToRead();
    }

    //переименовать если для статусов понадобятся клиенты еще в каком-то виде
    public Map<Long, Client> getClientsById(int shard, Collection<ClientId> clientIds) {
        List<Long> idsLong = clientIds.stream().map(ClientId::asLong).collect(Collectors.toList());
        return ppcDslContextProvider.ppc(shard).select(fields)
                .from(CLIENTS_OPTIONS)
                .where(CLIENTS_OPTIONS.CLIENT_ID.in(idsLong))
                .fetchMap(CLIENTS_OPTIONS.CLIENT_ID, reader::fromDb);
    }
}
