package ru.yandex.direct.core.aggregatedstatuses.repository.model;

public enum RecalculationDepthEnum {
    ALL("All"),
    CAMPAIGNS("Campaigns"),
    ADGROUPS("AdGroups"),
    ADGROUPSUBJECTS("AdGroupSubjects");

    private final String value;

    RecalculationDepthEnum(String value) {
        this.value = value;
    }

    public String value() {
        return value;
    }

    public static RecalculationDepthEnum fromValue(String value) {
        for (RecalculationDepthEnum depth: RecalculationDepthEnum.values()) {
            if (depth.value.equals(value)) {
                return depth;
            }
        }
        throw new IllegalArgumentException("Unexpected recalculation depth value: " + value);
    }
}
