package ru.yandex.direct.core.aggregatedstatuses.repository.model;

import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.moderationdiag.model.ModerationDiagType;

@ParametersAreNonnullByDefault
public class RejectReasonsAndCountersByIds<T> {
    private final Map<Long, Map<ModerationDiagType, Set<Long>>> rejectReasons;
    private final Map<Long, T> counters;

    public RejectReasonsAndCountersByIds(Map<Long, Map<ModerationDiagType, Set<Long>>> rejectReasons,
                                         Map<Long, T> counters) {
        this.rejectReasons = rejectReasons;
        this.counters = counters;
    }

    public Map<Long, Map<ModerationDiagType, Set<Long>>> getRejectReasons() {
        return rejectReasons;
    }

    public Map<Long, T> getCounters() {
        return counters;
    }
}
