package ru.yandex.direct.core.bsexport.repository.adgroup.resources

import org.springframework.stereotype.Repository
import ru.yandex.direct.dbschema.ppc.Tables.*
import ru.yandex.direct.dbutil.wrapper.DslContextProvider
import ru.yandex.direct.utils.JsonUtils


@Repository
class BsExportAdgroupMinusPhrasesRepository(private val dslContextProvider: DslContextProvider) {

    companion object {
        private var minusPhrasesType = JsonUtils.getTypeFactory().constructParametricType(List::class.java, String::class.java)
        const val SELECT_CHUNK_SIZE = 10_000
    }

    fun getAdGroupIdsForMinusWords(shard: Int, minusWordsIds: Collection<Long>): List<Long> {
        val adGroupIdsForMinusPhrases = dslContextProvider.ppc(shard)
            .select(PHRASES.PID)
            .from(PHRASES)
            .where(PHRASES.MW_ID.`in`(minusWordsIds))
            .fetch(PHRASES.PID)
        val adGroupIdsForLibraryMinusPhrases = dslContextProvider.ppc(shard)
            .select(ADGROUPS_MINUS_WORDS.PID)
            .from(ADGROUPS_MINUS_WORDS)
            .where(ADGROUPS_MINUS_WORDS.MW_ID.`in`(minusWordsIds))
            .fetch(ADGROUPS_MINUS_WORDS.PID)
        return (adGroupIdsForMinusPhrases + adGroupIdsForLibraryMinusPhrases).distinct()
    }

    fun getMinusPhrases(shard: Int, minusWordsIds: Collection<Long>): Map<Long, List<String>> {
        val result = mutableMapOf<Long, List<String>>()
        minusWordsIds
            .chunked(SELECT_CHUNK_SIZE)
            .map { getMinusPhrasesChunked(shard, it) }
            .forEach { result.putAll(it) }
        return result
    }

    fun getMinusPhrasesChunked(shard: Int, minusWordsIds: Collection<Long>): Map<Long, List<String>> {
        return dslContextProvider.ppc(shard)
            .select(MINUS_WORDS.MW_ID, MINUS_WORDS.MW_TEXT)
            .from(MINUS_WORDS)
            .where(MINUS_WORDS.MW_ID.`in`(minusWordsIds))
            .fetchMap(MINUS_WORDS.MW_ID, MINUS_WORDS.MW_TEXT)
            .mapValues { (_, minusPhrases) -> getMinusPhrasesList(minusPhrases) }
    }

    private fun getMinusPhrasesList(minusPhrasesString: String?): List<String> {
        return if (minusPhrasesString == null || minusPhrasesString == "") listOf()
        else {
            JsonUtils.fromJson(minusPhrasesString, minusPhrasesType)
        }
    }
}
