package ru.yandex.direct.core.bsexport.repository.adgroup.showconditions

import org.jooq.impl.DSL
import org.springframework.stereotype.Repository
import ru.yandex.direct.dbschema.ppc.enums.BannerPermalinksPermalinkAssignType
import ru.yandex.direct.dbschema.ppc.enums.BannerTurbolandingsStatusmoderate
import ru.yandex.direct.dbschema.ppc.enums.BannersBannerType
import ru.yandex.direct.dbschema.ppc.enums.BannersMinusGeoType
import ru.yandex.direct.dbschema.ppc.enums.BannersPerformanceStatusmoderate
import ru.yandex.direct.dbschema.ppc.enums.BannersPhoneflag
import ru.yandex.direct.dbschema.ppc.enums.BannersStatusarch
import ru.yandex.direct.dbschema.ppc.enums.BannersStatuspostmoderate
import ru.yandex.direct.dbschema.ppc.enums.BannersStatusshow
import ru.yandex.direct.dbschema.ppc.enums.CampaignsType
import ru.yandex.direct.dbschema.ppc.enums.ImagesStatusmoderate
import ru.yandex.direct.dbschema.ppc.enums.PhrasesStatuspostmoderate
import ru.yandex.direct.dbschema.ppc.tables.BannerPermalinks.BANNER_PERMALINKS
import ru.yandex.direct.dbschema.ppc.tables.BannerTurbolandings.BANNER_TURBOLANDINGS
import ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS
import ru.yandex.direct.dbschema.ppc.tables.BannersMinusGeo.BANNERS_MINUS_GEO
import ru.yandex.direct.dbschema.ppc.tables.BannersPerformance.BANNERS_PERFORMANCE
import ru.yandex.direct.dbschema.ppc.tables.Campaigns.CAMPAIGNS
import ru.yandex.direct.dbschema.ppc.tables.Images.IMAGES
import ru.yandex.direct.dbschema.ppc.tables.Phrases.PHRASES
import ru.yandex.direct.dbutil.wrapper.DslContextProvider

data class AdGroupShowConditionsGeoInfo(
    val geo: List<Long>,
    val minusGeo: List<Long>,
    val campaignId: Long
);

@Repository
class BsExportAdgroupShowConditionsGeoRepository(private val dslContextProvider: DslContextProvider) {

    fun getGeoInfoByAdGroupIds(shard: Int, adGroupIds: Collection<Long>): Map<Long, AdGroupShowConditionsGeoInfo> {
        if (adGroupIds.isEmpty()) {
            return emptyMap()
        }

        val concatenatedMinusGeoField = DSL.groupConcatDistinct(BANNERS_MINUS_GEO.MINUS_GEO).separator(",")
            .`as`(DSL.name("concatenatedMinusGeo"))

        val bannerHasSomethingToShow =  DSL.nvl(BANNERS.HREF, "").ne("")
            .or(BANNER_TURBOLANDINGS.TL_ID.isNotNull.and(BANNER_TURBOLANDINGS.STATUS_MODERATE.eq(BannerTurbolandingsStatusmoderate.Yes)))
            .or(BANNERS.BANNER_TYPE.`in`(
                BannersBannerType.dynamic,
                BannersBannerType.mobile_content,
                BannersBannerType.performance,
                BannersBannerType.cpm_outdoor,
                BannersBannerType.internal,
                BannersBannerType.cpm_indoor
            ))
            .or(
                BANNERS.BANNER_TYPE.`in`(BannersBannerType.image_ad, BannersBannerType.cpc_video)
                    .and(CAMPAIGNS.TYPE.eq(CampaignsType.mobile_content))
            )
            .or(BANNERS.PHONEFLAG.eq(BannersPhoneflag.Yes).and(BANNERS.VCARD_ID.isNotNull))
            .or(
                BANNER_PERMALINKS.PERMALINK_ASSIGN_TYPE.eq(BannerPermalinksPermalinkAssignType.manual)
                    .and(BANNER_PERMALINKS.PREFER_VCARD_OVER_PERMALINK.eq(0L))
            )
        val bannerActive = BANNERS.STATUS_SHOW.eq(BannersStatusshow.Yes)
            .and(BANNERS.STATUS_ARCH.eq(BannersStatusarch.No))
            .and(BANNERS.STATUS_POST_MODERATE.eq(BannersStatuspostmoderate.Yes))
            .and(
                BANNERS.BANNER_TYPE.notIn(
                    BannersBannerType.image_ad,
                    BannersBannerType.cpc_video,
                    BannersBannerType.mcbanner,
                    BannersBannerType.cpm_banner,
                    BannersBannerType.cpm_outdoor,
                    BannersBannerType.cpm_indoor,
                    BannersBannerType.cpm_audio)
                .or(IMAGES.BID.isNotNull.and(IMAGES.STATUS_MODERATE.eq(ImagesStatusmoderate.Yes)))
                .or(IMAGES.BID.isNull.and(BANNERS_PERFORMANCE.STATUS_MODERATE.eq(BannersPerformanceStatusmoderate.Yes)))
            )
        val minusGeo = dslContextProvider.ppc(shard)
            .select(PHRASES.PID, concatenatedMinusGeoField)
            .from(BANNERS)
            .join(PHRASES).on(PHRASES.PID.eq(BANNERS.PID))
            .join(CAMPAIGNS).on(CAMPAIGNS.CID.eq(BANNERS.CID))
            .leftJoin(BANNERS_MINUS_GEO).on(BANNERS_MINUS_GEO.BID.eq(BANNERS.BID))
            .leftJoin(IMAGES).on(IMAGES.BID.eq(BANNERS.BID))
            .leftJoin(BANNER_TURBOLANDINGS).on(BANNER_TURBOLANDINGS.BID.eq(BANNERS.BID))
            .leftJoin(BANNERS_PERFORMANCE).on(BANNERS_PERFORMANCE.BID.eq(BANNERS.BID))
            .leftJoin(BANNER_PERMALINKS).on(BANNER_PERMALINKS.BID.eq(BANNERS.BID))
            .where(BANNERS.PID.`in`(adGroupIds))
            .and(PHRASES.STATUS_POST_MODERATE.eq(PhrasesStatuspostmoderate.Yes))
            .and(bannerActive)
            .and(DSL.nvl(BANNERS_MINUS_GEO.TYPE, BannersMinusGeoType.current).eq(BannersMinusGeoType.current))
            .and(bannerHasSomethingToShow)
            .groupBy(PHRASES.PID)
            .fetchMap(PHRASES.PID, concatenatedMinusGeoField)

        return dslContextProvider.ppc(shard)
            .select(PHRASES.PID, PHRASES.CID, PHRASES.GEO)
            .from(PHRASES)
            .where(PHRASES.PID.`in`(adGroupIds))
            .fetchMap(PHRASES.PID) {
                geoFromDb(
                    it.getValue(PHRASES.GEO),
                    minusGeo[it.getValue(PHRASES.PID)],
                    it.getValue(PHRASES.CID)
                )
            }
    }

    private fun geoFromDb(dbGeo: String?, dbMinusGeo: String?, campaignId: Long): AdGroupShowConditionsGeoInfo  {
        return AdGroupShowConditionsGeoInfo(
            geoListFromDB(dbGeo),
            geoListFromDB(dbMinusGeo),
            campaignId
        )
    }

    private fun geoListFromDB(geo: String?): List<Long> {
        if (geo == null) {
            return listOf()
        }
        return geo.split(",").filter { it.isNotEmpty() }.map { it.toLong() }.distinct()
    }
}
