package ru.yandex.direct.core.bsexport.repository.bids

import ru.yandex.direct.core.bsexport.model.BsExportAbstractBid

interface BsExportBidsRepositoryInterface<T : BsExportAbstractBid> {
    /**
     * получить limit объектов по списку кампаний, упорядоченных и больших чем from
     */
    fun getBidsByCids(shard: Int, cids: List<Long>, limit: Int, from: T?): List<T>

    /**
     *     получить объекты по их id
     */
    fun getBids(shard: Int, ids: Collection<Long>): List<T>

    /**
     * получить id кампаний (упорядоченно) чтобы в ных было примерно bidsLimit объектов
     */
    fun getCids(shard: Int, lastCampaignId: Long, bidsLimit: Int): List<Long>
}
