package ru.yandex.direct.core.bsexport.repository.bids

import ru.yandex.direct.core.bsexport.model.BsExportAbstractBid

interface BsExportBidsWithParamsRepositoryInterface<T: BsExportAbstractBid> : BsExportBidsRepositoryInterface<T> {
    data class HrefParamKey(
        val id: Long,
        val cid: Long,
    )

    fun getBidsByHrefParams(shard: Int, keys: Collection<HrefParamKey>): List<T>

    fun getBidsByHrefParamsLazily(shard: Int, keys: Collection<HrefParamKey>): Sequence<T> =
        keys
            .chunked(BIDS_CHUNK_SIZE)
            .asSequence()
            .flatMap { keysChunk -> getBidsByHrefParams(shard, keysChunk) }

    companion object {
        private const val BIDS_CHUNK_SIZE = 10_000
    }
}
