package ru.yandex.direct.core.bsexport.repository.resources;

import java.util.Collection;
import java.util.List;

import org.springframework.stereotype.Repository;

import ru.yandex.direct.common.util.RepositoryUtils;
import ru.yandex.direct.core.bsexport.resources.model.BannerPermalink;
import ru.yandex.direct.core.bsexport.resources.model.PermalinkAssignType;
import ru.yandex.direct.core.bsexport.resources.model.StatusPublish;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.read.JooqReaderWithSupplier;
import ru.yandex.direct.jooqmapper.read.JooqReaderWithSupplierBuilder;

import static ru.yandex.direct.dbschema.ppc.tables.BannerPermalinks.BANNER_PERMALINKS;
import static ru.yandex.direct.dbschema.ppc.tables.Organizations.ORGANIZATIONS;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;

@Repository
public class BsExportBannerPermalinksRepository {
    private final DslContextProvider dslContextProvider;
    private final JooqReaderWithSupplier<BannerPermalink> reader;

    public BsExportBannerPermalinksRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
        this.reader = getReader();
    }

    public List<BannerPermalink> getPermalinks(int shard, Collection<Long> bids) {
        return dslContextProvider.ppc(shard)
                .select(reader.getFieldsToRead())
                .from(BANNER_PERMALINKS)
                .leftJoin(ORGANIZATIONS)
                .on(BANNER_PERMALINKS.PERMALINK.eq(ORGANIZATIONS.PERMALINK_ID))
                .where(BANNER_PERMALINKS.BID.in(bids))
                .fetch(reader::fromDb);
    }

    public List<Long> getBidsForPermalinks(int shard, Collection<Long> permalinks) {
        return dslContextProvider.ppc(shard)
                .selectDistinct(BANNER_PERMALINKS.BID)
                .from(BANNER_PERMALINKS)
                .where(BANNER_PERMALINKS.PERMALINK.in(permalinks))
                .fetch(BANNER_PERMALINKS.BID);
    }

    private JooqReaderWithSupplier<BannerPermalink> getReader() {
        return JooqReaderWithSupplierBuilder.builder(BannerPermalink::new)
                .readProperty(BannerPermalink.BANNER_ID, fromField(BANNER_PERMALINKS.BID))
                .readProperty(BannerPermalink.PERMALINK_ID, fromField(BANNER_PERMALINKS.PERMALINK))
                .readProperty(BannerPermalink.PREFER_VCARD_OVER_PERMALINK,
                        fromField(BANNER_PERMALINKS.PREFER_VCARD_OVER_PERMALINK).by(RepositoryUtils::booleanFromLong))
                .readProperty(BannerPermalink.PERMALINK_ASSIGN_TYPE,
                        fromField(BANNER_PERMALINKS.PERMALINK_ASSIGN_TYPE).by(PermalinkAssignType::fromSource))
                .readProperty(BannerPermalink.CHAIN_ID, fromField(BANNER_PERMALINKS.CHAIN_ID))
                .readProperty(BannerPermalink.STATUS_PUBLISH,
                        fromField(ORGANIZATIONS.STATUS_PUBLISH).by(StatusPublish::fromSource))
                .build();
    }
}
