package ru.yandex.direct.core.bsexport.repository.resources;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.bsexport.resources.model.Vcard;
import ru.yandex.direct.core.entity.vcard.repository.VcardMappings;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.read.JooqReaderWithSupplier;
import ru.yandex.direct.jooqmapper.read.JooqReaderWithSupplierBuilder;

import static ru.yandex.direct.dbschema.ppc.tables.BannerPermalinks.BANNER_PERMALINKS;
import static ru.yandex.direct.dbschema.ppc.tables.Vcards.VCARDS;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;

@Repository
public class BsExportBannerVcardsRepository {
    private final DslContextProvider dslContextProvider;
    private final JooqReaderWithSupplier<Vcard> reader;

    public BsExportBannerVcardsRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
        this.reader = getReader();
    }

    public Map<Long, Vcard> getVcards(int shard, Collection<Long> vcardIds) {
        return dslContextProvider.ppc(shard)
                .select(reader.getFieldsToRead())
                .from(VCARDS)
                .where(VCARDS.VCARD_ID.in(vcardIds))
                .fetchMap(VCARDS.VCARD_ID, reader::fromDb);
    }

    public List<Long> getBidsForPermalinks(int shard, Collection<Long> permalinks) {
        return dslContextProvider.ppc(shard)
                .selectDistinct(BANNER_PERMALINKS.BID)
                .from(BANNER_PERMALINKS)
                .where(BANNER_PERMALINKS.PERMALINK.in(permalinks))
                .fetch(BANNER_PERMALINKS.BID);
    }

    private JooqReaderWithSupplier<Vcard> getReader() {
        return JooqReaderWithSupplierBuilder.builder(Vcard::new)
                .readProperty(Vcard.VCARD_ID, fromField(VCARDS.VCARD_ID))
                .readProperty(Vcard.PHONE, fromField(VCARDS.PHONE).by(VcardMappings::phoneFromDb))
                .build();
    }
}
