package ru.yandex.direct.core.bsexport.repository.resources;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.bsexport.resources.model.MobileAppForBsExport;
import ru.yandex.direct.core.entity.banner.repository.BannerRelationsRepository;
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign;
import ru.yandex.direct.core.entity.campaign.repository.CampaignTypedRepository;
import ru.yandex.direct.core.entity.domain.model.Domain;
import ru.yandex.direct.core.entity.domain.repository.DomainRepository;
import ru.yandex.direct.core.entity.mobileapp.repository.MobileAppRepository;
import ru.yandex.direct.core.entity.mobilecontent.model.MobileContent;
import ru.yandex.direct.core.entity.mobilecontent.repository.MobileContentRepository;

@Repository
public class BsExportMobileContentRepository {
    private final CampaignTypedRepository campaignTypedRepository;
    private final DomainRepository domainRepository;
    private final BannerRelationsRepository bannerRelationsRepository;
    private final MobileContentRepository mobileContentRepository;
    private final MobileAppRepository mobileAppRepository;

    public BsExportMobileContentRepository(CampaignTypedRepository campaignTypedRepository,
                                           DomainRepository domainRepository,
                                           BannerRelationsRepository bannerRelationsRepository,
                                           MobileContentRepository mobileContentRepository,
                                           MobileAppRepository mobileAppRepository) {
        this.campaignTypedRepository = campaignTypedRepository;
        this.domainRepository = domainRepository;
        this.bannerRelationsRepository = bannerRelationsRepository;
        this.mobileContentRepository = mobileContentRepository;
        this.mobileAppRepository = mobileAppRepository;
    }

    public List<Long> getBannerIdsByCampaignIds(int shard, Collection<Long> campaignIds) {
        if (campaignIds.isEmpty()) {
            return List.of();
        }
        return bannerRelationsRepository.getBannerIdsByCampaignIds(shard, campaignIds);
    }

    public List<Long> getBannerIdsByAdGroupIds(int shard, Collection<Long> adGroupIds) {
        if (adGroupIds.isEmpty()) {
            return List.of();
        }
        return bannerRelationsRepository.getBannerIdsByAdGroupIds(shard, adGroupIds);
    }

    public List<Long> getAdgroupIdsForMobileContentIds(int shard, Collection<Long> mobileContentIds) {
        if (mobileContentIds.isEmpty()) {
            return List.of();
        }
        return mobileContentRepository.getAdgroupIdsForMobileContentIds(shard, mobileContentIds);
    }

    public Map<Long, MobileContent> getMobileContentByAdGroupIds(int shard, Collection<Long> adGroupIds) {
        if (adGroupIds.isEmpty()) {
            return Map.of();
        }
        return mobileContentRepository.getMobileContentByAdGroupIds(shard, adGroupIds);
    }

    public Map<Long, String> getStoreUrlByAdGroupIds(int shard, Collection<Long> adGroupIds) {
        if (adGroupIds.isEmpty()) {
            return Map.of();
        }
        return mobileContentRepository.getStoreUrlByAdGroupIds(shard, adGroupIds);
    }

    public List<Domain> getDomainsByIdsFromDict(Collection<Long> domainIds) {
        if (domainIds.isEmpty()) {
            return List.of();
        }
        return domainRepository.getDomainsByIdsFromDict(domainIds);
    }

    public List<CommonCampaign> getCampaigns(int shard, Collection<Long> campaignIds) {
        if (campaignIds.isEmpty()) {
            return List.of();
        }
        return campaignTypedRepository.getSafely(shard, campaignIds, CommonCampaign.class);
    }

    public Map<Long, MobileAppForBsExport> getMobileAppsForCampaigns(int shard, Collection<Long> campaignIds) {
        if (campaignIds.isEmpty()) {
            return Map.of();
        }
        return mobileAppRepository.getCampaignsMobileAppsForBsExport(shard, campaignIds);
    }
}
