package ru.yandex.direct.core.configuration;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.AdviceMode;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.method.configuration.GlobalMethodSecurityConfiguration;

import ru.yandex.direct.core.security.authorization.AccessDecisionManagerWrapper;
import ru.yandex.direct.core.security.authorization.DirectPermissionEvaluator;

/**
 * <code>@EnableGlobalMethodSecurity</code> prePostEnabled attribute enables
 * expressions in <code>@PreAuthorize</code>-annotations
 */
@EnableGlobalMethodSecurity(securedEnabled = true,
        prePostEnabled = true, mode = AdviceMode.PROXY, proxyTargetClass = true)
public class AuthorizationConfiguration extends GlobalMethodSecurityConfiguration {

    @Autowired
    private DirectPermissionEvaluator permissionEvaluator;

    /**
     * Disables authentication at authorization-time.
     * Authentication must be completed before.
     */
    @Override
    protected AuthenticationManager authenticationManager() throws Exception {
        return (authentication -> authentication);
    }

    @Override
    public MethodSecurityExpressionHandler createExpressionHandler() {
        DefaultMethodSecurityExpressionHandler expressionHandler =
                new DefaultMethodSecurityExpressionHandler();
        expressionHandler.setPermissionEvaluator(permissionEvaluator);
        return expressionHandler;
    }

    @Override
    protected AccessDecisionManager accessDecisionManager() {
        AccessDecisionManager sourceManager = super.accessDecisionManager();
        return new AccessDecisionManagerWrapper(sourceManager);
    }
}
