package ru.yandex.direct.core.configuration;

import com.amazonaws.auth.AWSCredentials;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class MdsS3Token implements AWSCredentials {
    private final String accessKeyId;

    private final String accessSecretKey;

    @JsonCreator
    public MdsS3Token(@JsonProperty("AccessKeyId") String accessKeyId,
                      @JsonProperty("AccessSecretKey") String accessSecretKey) {
        this.accessKeyId = accessKeyId;
        this.accessSecretKey = accessSecretKey;
    }

    @Override
    public String getAWSAccessKeyId() {
        return accessKeyId;
    }

    @Override
    public String getAWSSecretKey() {
        return accessSecretKey;
    }
}
