package ru.yandex.direct.core.copyentity;

import java.time.Duration;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.common.lettuce.LettuceConnectionProvider;
import ru.yandex.direct.redislock.DistributedLock;
import ru.yandex.direct.redislock.lettuce.LettuceLockBuilder;

@Component
@ParametersAreNonnullByDefault
public class CopyLocker {
    private final LettuceLockBuilder lockBuilder;

    public CopyLocker(LettuceConnectionProvider lettuce) {
        this.lockBuilder = LettuceLockBuilder.newBuilder(lettuce::getConnection)
                .withMaxLocks(1)
                .withLockAttemptTimeout(300)
                .withKeyPrefix("copy-entity")
                .withTTL(Duration.ofMinutes(10).toMillis());
    }

    public DistributedLock create(String key) {
        return lockBuilder.createLock(key);
    }
}
