package ru.yandex.direct.core.copyentity;

import java.util.AbstractList;
import java.util.List;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Список отдельного класса, нужен, чтобы в PathNodeConverter можно было вешать правило конвертирования путей на
 * корневой список ValidationResult (см. например
 * ru.yandex.direct.grid.processing.service.group.validation.AdGroupCopyValidationService::createErrorPathConverters)
 *
 * @param <KeyT> тип элемента списка
 */
@ParametersAreNonnullByDefault
public class CopyResultIds<KeyT> extends AbstractList<KeyT> {
    private final List<KeyT> ids;

    CopyResultIds(List<KeyT> ids) {
        this.ids = ids;
    }

    public List<KeyT> getIds() {
        return ids;
    }

    @Override
    public KeyT get(int index) {
        return ids.get(index);
    }

    @Override
    public int size() {
        return ids.size();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CopyResultIds<?> that = (CopyResultIds<?>) o;
        return Objects.equals(ids, that.ids);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), ids);
    }
}
