# Операция копирования объектов и всего дерева их подобъектов.

## Содержание
- how-to как использовать/вызывать
- how-to как поддерживать новые сущности
- как это работает, developer's manual

## Как копирование конфигурировать и вызывать
### копирование групп внутри одной кампании
```
CopyConfig copyConfig = CopyConfig.sameClient(shard, client, operatorUid)   // копируем внутри одного клиента на этом шарде под этим оператором
        .copyEntities(AdGroup.class).withIds(adGroupIds);                   // будем копировать группы с этими идентификаторвами
var groups = adGroupService.getSimpleAdGroups(clientId, adGroupIds);
// Проставляем, куда копировать
for (var group : groups.values()) {                                         // проставляем, откуда и куда копируем (например, группы копируем с кампании A в кампанию B)
    copyConfig.copyingFromEntity(BaseCampaign.class)                        // с кампании
            .withId(group.getCampaignId())                                  // с id
            .toEntityWithId(nvl(destinationCampaignId, group.getCampaignId())); // в кампанию с id
}

var operation = copyOperationFactory.build(copyConfig);                     // создаем операцию

var copyResult = operation.copy();                                          // вызываем копирование
copyResult.logFailedResultsForMonitoring();                                 // пишем в лог все ошибки и ворнинги, возникшие при копировании

var massResult = copyResult.getMassResult();                                // получить массовый результат копирования (внутри него находится иерархический ValidationResult, с путями вида [0].Ad[1].Title)
```
### копирование кампаний между клиентами
```
var clientFrom = clientService.getClient(clientIdFrom);                 // получаем клиентов и шарды
var shardFrom = shardHelper.getShardByClientIdStrictly(clientIdFrom);

var clientTo = clientService.getClient(clientIdTo);
var shardTo = shardHelper.getShardByClientIdStrictly(clientIdTo);

var copyConfig = new CopyConfig(shardFrom, requireNonNull(clientFrom),  // копируем с этого клиента с этого шарда
        shardTo, requireNonNull(clientTo),                              // на этого клиента на этом шарде
        operatorUid)                                                    // под этим оператором
        .copyEntities(BaseCampaign.class).withIds(campaignIds);         // копируем кампании с этими id
                                                                        // дополнительно указывать откуда куда не надо - с клиента на клиента, а это уже указано
var operation = copyOperationFactory.build(copyConfig);                 // создаем операцию
var copyResult = operation.copy();                                      // копируем
copyResult.logFailedResultsForMonitoring();                             // логируем ошибки и ворнинги

```

## Основные особенности копирования
- копирование НЕ транзакционно, может скопировать только часть объектов, по остальным выдаст в своем результате ошибки,
почему объекты не были скопированы
- копирование работает через получение сущностей, потом добавление их как новых в базу, для этого используются стандартные
сервисы сущностей get и add, за счет этого не надо отдельно делать валидацию, проверять права, поддерживать копирование отдельно
- копирование сначала получает все объекты всех типов в дереве, потом их все добавляет - так более эффективно, и остается
контекст с полученными/добавленными объектами
- копирование определяет, что копировать, что нет, по моделям, и их связям (новый тип модели, который генерируется из одного
из атрибутов)

## Вам стоит/нужно поддержать копирование, если
- вы добавляете новые сущности в уже поддержанные в копировании (кампании ТГО внутри/между клиентами, группы ТГО, кампании и группы Смартов) - список можно расширять
- вы хотите что-то копировать (плюсы CopyEntity - иерархическое, из коробки поддерживает валидации, несложно в поддержке)
- вы поддерживаете новые типы групп/кампаний в копировании

## Как добавлять новые типы к копированию

Механизм копирования работает на основе графа, в котором узлами являются сущности ядра, а ребрами - связи между ними. Граф
описывается при помощи специальных классов и интерфейсов, а механизм копирования (сейчас называется CopyEntity) считывает
его в рантайме при помощи сканирования classpath. Поддержка описания графа встроена в model-generator (direct/libs/model-generator/CONFIG_FORMAT.md),
таким образом конфиги моделей ядра являются не только описанием конечных классов и интерфейсов, но и описанием графа копирования.
Так же при сканировании инструмент ищет сервисы, помеченные специальными интерфейсами, для выполнения непосредственно копирования.
Cущность ядра - это модель (Banner, AdGroup и т.д.), вдобавок помеченная специальным интерфейсом Entity. Под связкой понимается
отношение а-ля в базе foreign key -> primary key, в моделях это реализуется моделью Relationship, генерирующейся из
атрибута поля в модели, соответствующего внешнему ключу на ребенке.

*Пример conf-файла:*
```
package: ru.yandex.direct.core.entity.adgroup.model
name: AdGroup
modifiers: [PUBLIC]
implements: [ru.yandex.direct.model.Entity<Long>]
...
attrs: [
  {name: id, type: Long}
  {name: campaignId, type: Long, relationship:
    {name: CampaignContainsAdGroups, parent: ru.yandex.direct.core.entity.campaign.model.BaseCampaign}}
  {name: type, type: AdGroupType}
  ...
]
```
Каждому классу сущности соответствует сервис сущности, который умеет производить основные операции, необходимые для копирования -
получить сущности по id (get), добавить новую сущность в базу (add). Обычно этот интерфейс реализует текущий ядровый сервис
для этой сущности - т.е. BannerService для Banner, AdGroupService для AdGroup и т.п. Для связок есть аналогичный сервис
связи, который умеет получать id детей по id родителей (в обратном направлении достаточно прочитать значение внешнего ключа
на ребенке). Сейчас это обычно отдельный класс сервиса, так как у сущности может быть/обычно много связей, а у связи два
конца - две сущности. Для каждой сущности должен быть свой сервис сущности, а для каждой связи - свой сервис связи, код при старте
проверяет их наличие, и если какого-либо не хватает - выкидывает исключение. Пример сервиса сущности - BannerService, пример
сервиса связи между сущностями - AdGroupWithBannersService.

Таким образом, чтобы добавить какую-либо сущность к копированию, нужно
- проложить дорожку связки к нужной сущности от какой-либо уже копируемой сущности. Если такой дорожки в один шаг нет, то
надо добавить в копирование другую сущность, к которой такую дорожку можно проложить, и от нее уже проложить дорожку к текущей
сущности. Добавить соответствующий Relationship в нужную модель (если текущая сущность - родитель в связке, то в ту сущность,
откуда идет связь, если ребенок - то в текущую). Например, если мы хотим добавить копирование Banner, и у нас уже копируются
AdGroup, то мы в Banner на поле adGroupId добавляем связку AdGroupContainsBanners
- добавить соответствующий новой связке RelationshipService, реализовать метод getIdsByParentIds. В нашем примере - добавляем
сервис BannersOfAdGroups, в нем реализуем метод getIdsByParentIds через получение bannerIds by adGroupIds
- пометить нужную сущность интерфейсом Entity - в нашем примере в модель i_banner.conf добавляем implements: [Entity&lt;Long&gt;]
- прописать в ее сервис интерфейс EntityService, реализовать методы get и add. В нашем примере в BannerService добавляем
addBanners
- если нужно, пометить сущность интерфейсами ClientLibraryObject (если сущность хранится на клиенте) или CampaignLibraryObject
(если на кампании). Например, Vcard нужно пометить интерфейсом CampaignLibraryObject, а RetargetingCondition - интерфейсом
ClientLibraryObject. В нашем примере Banner ни одним из этих интерфейсов помечать не надо.
- для остальных связок этой сущности при необходимости добавить копирование их/связанных ими сущностей. В нашем примере
надо добавить связку с Vcard.

## Примеры поддержки копирования
I. Совсем новое дерево
Пусть есть типы A, B и C, в каждом из них есть id типа Long. Тип A содержит несколько B, соответственно, B.a_id = A.id,
также B содержит один C (который может содержаться в нескольких B), то есть B.c_id = C.id. C - библиотечный элемент,
хранится на клиенте.
#### Модифицируем модели (добавляем реализацию Entity<Тип ключа>, добавляем атрибут Relationship на внешние ключи, для
   библиотечных объектов ставим маркерные интерфейсы Campaign/ClientLibraryObject)

A:
```
name: A
implements: [ru.yandex.direct.model.Entity<Long>]
attrs: [
  {name: id, type: Long}
]
```
B:
```
name: B
implements: [ru.yandex.direct.model.Entity<Long>]
attrs: [
  {name: id, type: Long}
  {name: aId, type: Long, relationship: {name: AContainsBs, parent: A}}
  {name: cId, type: Long, relationship: {name: CConnectedToBs, parent: C}}
]
```
C:
```
name: C
implements: [ru.yandex.direct.model.Entity<Long>, ClientLibraryObject]
attrs: [
  {name: id, type: Long}
]
```
Генерируем модели, у нас сгененируются два новых класса
```
AContainsBs implements Relationship<A, B, Long> // (родитель, ребенок, тип A.id/B.a_id)
CConnectedToBs implements Relationship<C, B, Long> // (C считается родителем, так как в нем первичный ключ)
```
#### Добавляем сервисы сущностей (добавляем к имеющимся/создаем новые сервисы, реализующие интерфейс
Entity<тип сущности, тип ее первичного ключа>, реализуем два метода этого интерфейса - get и add)

```
public class AService implements EntityService<A, Long> {
    public MassResult<Long> add(ClientId clientId, Long operatorUid, List<A> entities, Applicability applicability) {
        // добавить A в базу
    }

    public List<A> get(ClientId clientId, Long operatorId, Collection<Long> ids) {
        // получить из базы A по A.id
    }
}
```

Сервисы для B и C аналогично

#### Добавляем сервисы связей (создаем новые классы, реализующие интерфейс
   RelationshipService<класс связи, тип первичного ключа родителя, тип первичного ключа ребенка>)
```
public class AWithBsService implements RelationshipService<AContainsBs, Long, Long> {
    @Override
    public Set<Long> getChildEntityIdsByParentIds(ClientId clientId, Long operatorId, Set<Long> aIds) {
        // получить по A их детей B, в смысле по набору A.id все B, у которых B.a_id в этом наборе
    }
}
```
И тестируем, все должно заработать.

II. Добавление объекта к текущему дереву
Аналогично новому дереву, но часть уже кто-то сделал, смотрим, что есть, чего не хватает.

## Технические подробности копирования
Внутри копирование происходит в два этапа, плюс небольшая промежуточная стадия:
### Получить все копируемые объекты
Код рекурсивно обходит дерево объектов, начиная с указанных в конфигурации и вниз по связям "родитель-ребенок". Для
каждого уровня дерева забираются все объекты на этом уровне, которые должны быть скопированы. На этом этапе также есть
возможность через плагины (prefilters) выкинуть те объекты, которые по тем или иным причинам копировать не хочется (так
например сделано не-копирование архивных объектов). Все объекты складываются в контекст по типам и id, и в конце контекст
содержит полный набор объектов для копирования.

Важный момент - получаются не только "дети", но и "родители". И дети, и родители получаются только если в контексте еще
нет их id-шников, это позволяет избежать зацикливания (и по факту через мэппинг в контексте мы задаем, откуда и куда
копировать). Помимо этого и префильтрации, еще выбираемые объекты ограничиваются следующим:
- сущности, помеченные CampaignLibraryObject, не выбираются, если копирование идет внутри кампании
- сущности, помеченные ClientLibraryObject, не выбираются, если копирование идет внутри клиента
- есть возможность (передавая в фабрику операции) указать связи, по которым нужно забирать объекты только при проходе в
одну сторону. Звучит сложно, поэтому пример - в баннере прописана визитка, и мы хотим ее копировать при копировании
между кампаниями, но мы не хотим копировать ВСЕ баннеры, ссылающиеся на эту визитку. Пусть есть визитка В, она привязана
к баннерам А и Б в группах 1 и 2, копируем группу 1, копируем баннер А, копируем визитку В, дальше, если нет ограничения,
копируем баннер Б, группу 2 -  не то что мы хотели. Таким образом нужно добавить ограничение "брать визитки, связанные с
баннерами, не брать баннеры, связанные с визитками".

Для примера, при копировании групп 1, 2 и 3 код:
- забирает сами группы 1, 2, 3
- получает id баннеров групп 1-2-3
- получает баннеры по этим id
- получает id ключевых фраз групп 1-2-3
- получает ключевые фразы по id
- то же самое для ретаргетингов и relevance match
- для баннеров получаются их визитки
- если у баннеров или у других сущностей есть подобъекты, то получаются и они
- получались бы и условия ретаргетинга для ретаргетингов, если бы мы умели копировать цели в Метрике

Получение происходит через обычный массовый сервис get, практически всегда все сущности одного типа получаются за один
запрос (будет не так, если одни и та же сущность может быть привязана к нескольким объектам, например корректировки на
кампаниях и группах), так что достаточно эффективно. Так можно в принципе получить произвольное дерево объектов, даже не
обязательно для копирования.

### Промежуточный этап - превалидация
Еще один вид плагинов, можно объекты каждого типа превалидировать, если найдена какая-то ошибка - копирование дальше не
идет. Это сделано для того, чтобы была возможность остановить копирование в случае критических ошибок, так как обычно
копирование ошибочные сущности пропускает, и идет дальше. В превалидацию передается контекст целиком, так что можно
валидировать не только сам объект, но и его связи, вплоть до целого дерева.

### Добавление в базу
Код идет по дереву, для каждого типа объекта забирает все объекты из контекста и разом добавляет их в базу. На этом
этапе есть третий (и последний) вид плагинов - препроцессор. Он позволяет перед ставкой допилить сущности напильником.
В целом копирование предполагает соблюдение определенного контракта сервисами get и add:
- get возвращает те сущности, которые принимает add
- результат get можно передать в add, и он практически всегда вставится
Но из этого контракта есть исключения, есть логичные (например, дата начала не может быть раньше текущей у новой кампании),
есть нелогичные (так исторически сложилось/так сделали/таково продуктовое требование). Препроцессинг - место, где такие
вещи можно поправить, проставить нужную дату, обнулить поля, которые требуются в null, ну и даже ручками вставить
дополнительные объекты (так делать не стоит без крайней необходимости).

Вставка происходит через обычный массовый сервис add, в котором уже зашиты валидация, обработка статусов модерации и БК,
и все это руками прописывать не нужно. Все объекты одного типа вставляются за один вызов, что достаточно эффективно. Если
родительский объект не был вставлен, например, не прошел валидацию, то все его потомки тоже не будет вставлены.
Этим же механизмом можно в принципе добавить произвольное дерево объектов в базу, не обязательно только для копирования.

По результатам добавления изготавливается результат копирования. Он состоит из двух частей - общего массового результата
копирования и контекста копирования. Внутри массового результата, как и во всех массовых результатах, есть результат
валидации - склеенные в дерево результаты валидации отдельных операций добавления. Склеен в дерево результат валидации
аналогично дереву сущностей, то есть например для копирования кампаний ошибки валидации будут с путями
[1].AdGroup[2].Ad[1].Title и подобными. Если сработала превалидация, и ничего скопировано не было, то в результате
валидации будут результаты превалидации.

В контексте копирования хранятся объекты, полученные get, и добавленные add (если они добавлялись). Если у объекта в
контексте id не изменился (объекты хранятся в мапе старый id -> объект), то значит он не копировался вообще по каким-то
причинам, например, кто-то из его предков не был скопирован. Если id объекта - null, значит объект мы пытались скопировать,
но что-то пошло не так, обычно это он не прошел валидацию. Если id изменился - то объект был добавлен, и это id
скопированного объекта.
