package ru.yandex.direct.core.copyentity;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.model.Relationship;

/**
 * Сервис связи между сущностями, предоставляет самые необходимые методы для работы с ней
 *
 * @param <T>          тип связи между сущностями/relationship
 * @param <ParentKeyT> тип первичного ключа родителя в связи
 * @param <ChildKeyT>  тип первичного ключа ребенка в связи
 */
@ParametersAreNonnullByDefault
public interface RelationshipService<T extends Relationship<?, ?, ParentKeyT>, ParentKeyT, ChildKeyT> {
    /**
     * По набору id родителей получает набор id детей этих родителей - текущих объектов
     *
     * @param clientId   id клиента - владельца всех сущностей
     * @param operatorId id оператора, из под которого производиткся поиск
     * @param parentIds  набор id сущностей-родителей
     * @return набор id сущностей-детей
     */
    Set<ChildKeyT> getChildEntityIdsByParentIds(ClientId clientId, Long operatorId, Set<ParentKeyT> parentIds);
}
