package ru.yandex.direct.core.copyentity.mediators

import ru.yandex.direct.core.copyentity.CopyOperationContainer
import ru.yandex.direct.core.copyentity.EntityContext
import ru.yandex.direct.result.MassResult

/**
 * Получает граф копирования, после того, как он был целиком загружен, модифицирует его, а так же наполняет
 * контейнер копирования дополнительной информацией для препроцессоров.
 * Предпосылки создания этого интерфейса были такие:
 * Порядок вызова препроцессоров в общем случае не определен, и в препроцессоре нельзя отказаться
 * от копирования сущности. Однако от внутреннего состояния сущностей может зависеть, копировать связанные
 * с ними другие сущности или нет (например, от состояния стратегии в кампании зависит, копировать или нет
 * ее ключевые цели в метрике). Так что в препроцессорах реализовать подобную логику в текущей архитектуре невозможно.
 * На этапе префильтрации мы тоже не можем загрузить дочерние объекты только для части родительских, они грузятся
 * всегда для всех. Добавление такой возможности заметно усложнило бы интерфейс префильтров и алгоритм хождения
 * по графу, поэтому решили сделать отдельную стадию обработки всего графа сразу после его полной загрузки,
 * и перед запуском препроцессоров.
 */
interface CopyMediator {
    /**
     * Обрабатывает граф, меняет его, и добавляет дополнительную информацию в контейнер. Должен возвращать пустую
     * карту с результатами, если нет ошибок. В возвращаемой карте с результатами должны быть только
     * ошибочные результаты
     */
    fun mediate(context: EntityContext, copyContainer: CopyOperationContainer): Map<Class<*>, MassResult<*>>
}
