package ru.yandex.direct.core.copyentity.mediators

import ru.yandex.direct.core.copyentity.CopyOperationContainer
import ru.yandex.direct.core.copyentity.EntityContext
import ru.yandex.direct.result.MassResult

/**
 * Собирает все медиаторы, и вызывает их по очереди, до первой ошибки (или все до конца, если ошибок нет)
 */
open class CopyMediatorsFacade(
    private val mediators: List<CopyMediator>,
): CopyMediator {
    override fun mediate(
        context: EntityContext,
        copyContainer: CopyOperationContainer
    ): Map<Class<*>, MassResult<*>> {
        for (copyMediator: CopyMediator in mediators) {
            val result: Map<Class<*>, MassResult<*>> = copyMediator.mediate(context, copyContainer)
            if (result.isNotEmpty()) {
                return result
            }
        }
        return mutableMapOf()
    }
}
