package ru.yandex.direct.core.copyentity.model

import com.fasterxml.jackson.annotation.JsonProperty

data class CopyCampaignFlags(
    /**
     * Если `false`, остановленные баннеры не будут скопированы
     */
    @JsonProperty("copy_stopped")
    @get:JsonProperty("copy_stopped")
    val isCopyStopped: Boolean = false,

    /**
     * Если `false`, архивные баннеры не будут скопированы
     */
    @JsonProperty("copy_archived")
    @get:JsonProperty("copy_archived")
    val isCopyArchived: Boolean = false,

    /**
     * Если false, архивные кампании не будут копироваться
     */
    @JsonProperty("copy_archived_campaigns")
    @get:JsonProperty("copy_archived_campaigns")
    val isCopyArchivedCampaigns: Boolean = false,

    /**
     * Если `true`, у скопированной кампании будут те же настройки уведомлений, что у исходной, в том числе если
     * кампания была скопирована другому клиенту
     */
    @JsonProperty("copy_notification_settings")
    @get:JsonProperty("copy_notification_settings")
    val isCopyNotificationSettings: Boolean = false,

    /**
     * Если `true`, кампания будет отправлена в модерацию, если исходная кампания не была черновиком
     */
    @JsonProperty("copy_campaign_statuses")
    @get:JsonProperty("copy_campaign_statuses")
    val isCopyCampaignStatuses: Boolean = false,

    /**
     * Имеет значение только при копировании между клиентами. Если `true`, то конверсионные стратегии будут скопированы
     * вместе с достижениями целей, при наличии у целевого клиента доступов к целям метрики. Иначе (если флаг `false`,
     * либо если стратегия не может быть скопирована), стратегия будут сброшена на недельный бюджет.
     * [Текстовое описание логики](https://st.yandex-team.ru/DIRECT-161116#6218b937ae42af044c0cd97e)
     */
    @JsonProperty("copy_conversion_strategies")
    @get:JsonProperty("copy_conversion_strategies")
    val isCopyConversionStrategies: Boolean = false,

    /**
     * Имеет значение только при копировании между клиентами. Если `true`, достижения целей метрики будут скопированы
     * независимо от наличия у целевого клиента доступа к ним. Также, при `isCopyConversionStrategies = true`,
     * конверсионная стратегия будет скопирована даже без доступа к целям метрики
     */
    @JsonProperty("do_not_check_rights_to_metrika_goals")
    @get:JsonProperty("do_not_check_rights_to_metrika_goals")
    val isDoNotCheckRightsToMetrikaGoals: Boolean = false,

    /**
     * Если `true`, будут скопированы статус остановленности (`statusShow`) и архивности (`statusArchived`) баннера.
     * Также, баннер будет отправлен в модерацию, если он не является черновиком. Баннеры, не прошедшие модерацию в
     * исходной кампании, будут остановлены
     */
    @JsonProperty("copy_banner_statuses")
    @get:JsonProperty("copy_banner_statuses")
    val isCopyBannerStatuses: Boolean = false,

    /**
     * Если `true`, будет скопирован статус остановленности фраз (`isSuspended`)
     */
    @JsonProperty("copy_keyword_statuses")
    @get:JsonProperty("copy_keyword_statuses")
    val isCopyKeywordStatuses: Boolean = false,

    /**
     * Если `true`, скопированная кампания будет остановлена
     */
    @JsonProperty("stop_copied_campaigns")
    @get:JsonProperty("stop_copied_campaigns")
    val isStopCopiedCampaigns: Boolean = false,

    /**
     * Если `true`, после копирования кампании будут сгенерированы отчеты с соответствием id объектов
     */
    @JsonProperty("generate_report")
    @get:JsonProperty("generate_report")
    val isGenerateReport: Boolean = false,
) {
    class Builder {
        private var isCopyStopped: Boolean = false
        private var isCopyArchived: Boolean = false
        private var isCopyNotificationSettings: Boolean = false
        private var isCopyCampaignStatuses: Boolean = false
        private var isCopyConversionStrategies: Boolean = false
        private var isDoNotCheckRightsToMetrikaGoals: Boolean = false
        private var isCopyBannerStatuses: Boolean = false
        private var isCopyKeywordStatuses: Boolean = false
        private var isStopCopiedCampaigns: Boolean = false
        private var isGenerateReport: Boolean = false

        fun withCopyStopped(isCopyStopped: Boolean): Builder {
            this.isCopyStopped = isCopyStopped
            return this
        }

        fun withCopyArchived(isCopyArchived: Boolean): Builder {
            this.isCopyArchived = isCopyArchived
            return this
        }

        fun withCopyNotificationSettings(isCopyNotificationSettings: Boolean): Builder {
            this.isCopyNotificationSettings = isCopyNotificationSettings
            return this
        }

        fun withCopyCampaignStatuses(isCopyCampaignStatuses: Boolean): Builder {
            this.isCopyCampaignStatuses = isCopyCampaignStatuses
            return this
        }

        fun withCopyConversionStrategies(isCopyConversionStrategies: Boolean): Builder {
            this.isCopyConversionStrategies = isCopyConversionStrategies
            return this
        }

        fun withDoNotCheckRightsToMetrikaGoals(isDoNotCheckRightsToMetrikaGoals: Boolean): Builder {
            this.isDoNotCheckRightsToMetrikaGoals = isDoNotCheckRightsToMetrikaGoals
            return this
        }

        fun withCopyBannerStatuses(isCopyBannerStatuses: Boolean): Builder {
            this.isCopyBannerStatuses = isCopyBannerStatuses
            return this
        }

        fun withCopyKeywordStatuses(isCopyKeywordStatuses: Boolean): Builder {
            this.isCopyKeywordStatuses = isCopyKeywordStatuses
            return this
        }

        fun withStopCopiedCampaigns(isStopCopiedCampaigns: Boolean): Builder {
            this.isStopCopiedCampaigns = isStopCopiedCampaigns
            return this
        }

        fun withGenerateReport(isGenerateReport: Boolean): Builder {
            this.isGenerateReport = isGenerateReport
            return this
        }

        fun build() = CopyCampaignFlags(
            isCopyStopped = isCopyStopped,
            isCopyArchived = isCopyArchived,
            isCopyNotificationSettings = isCopyNotificationSettings,
            isCopyCampaignStatuses = isCopyCampaignStatuses,
            isCopyConversionStrategies = isCopyConversionStrategies,
            isDoNotCheckRightsToMetrikaGoals = isDoNotCheckRightsToMetrikaGoals,
            isCopyBannerStatuses = isCopyBannerStatuses,
            isCopyKeywordStatuses = isCopyKeywordStatuses,
            isStopCopiedCampaigns = isStopCopiedCampaigns,
            isGenerateReport = isGenerateReport,
        )
    }
}
