package ru.yandex.direct.core.copyentity.prefilters

import org.springframework.stereotype.Component
import ru.yandex.direct.core.copyentity.CopyOperationContainer
import ru.yandex.direct.core.entity.banner.model.BannerWithAdGroupId
import ru.yandex.direct.core.entity.banner.model.BannerWithStatusArchived
import ru.yandex.direct.core.entity.banner.model.BannerWithStatusShow
import ru.yandex.direct.validation.builder.Constraint
import ru.yandex.direct.validation.builder.Constraint.fromPredicate
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.defect.CommonDefects
import ru.yandex.direct.validation.defect.CommonDefects.invalidValue
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.util.validateList
import javax.annotation.ParametersAreNonnullByDefault

@Component
class BannerPrefilter : EntityPrefilter<BannerWithAdGroupId> {
    override fun prefilter(
        entities: List<BannerWithAdGroupId>,
        copyContainer: CopyOperationContainer,
    ): ValidationResult<List<BannerWithAdGroupId>, Defect<*>> {
        return validateList(entities) {
            checkEach(
                fromPredicate({ !(it as BannerWithStatusArchived).statusArchived }, invalidValue()),
                When.isFalse(copyContainer.flags.isCopyArchived),
            )
            checkEach(
                fromPredicate({ (it as BannerWithStatusShow).statusShow }, invalidValue()),
                When.isFalse(copyContainer.flags.isCopyStopped),
            )
        }
    }
}
