package ru.yandex.direct.core.copyentity.prefilters;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.banner.model.BannerWithAdGroupId;
import ru.yandex.direct.core.entity.campaign.model.BaseCampaign;

@ParametersAreNonnullByDefault
@Component
public class CopyPrefilter extends Prefilter {
    public CopyPrefilter(AdGroupPrefilter adGroupPrefilter,
                         BannerPrefilter bannerPrefilter,
                         CampaignPrefilter campaignPrefilter) {
        this.addPrefilter(AdGroup.class, adGroupPrefilter);
        this.addPrefilter(BannerWithAdGroupId.class, bannerPrefilter);
        this.addPrefilter(BaseCampaign.class, campaignPrefilter);
    }
}
