package ru.yandex.direct.core.copyentity.preprocessors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.copyentity.CopyOperationContainer;
import ru.yandex.direct.core.entity.bidmodifier.BidModifier;

/**
 * Делает преодбработку BidModifier перед копированием
 */
@Component
@ParametersAreNonnullByDefault
public class BidModifierCopyPreprocessor implements CopyPreprocessorTypeSupport<BidModifier> {

    @Override
    public Class<BidModifier> getTypeClass() {
        return BidModifier.class;
    }

    @Override
    public void preprocess(BidModifier bidModifier, CopyOperationContainer copyContainer) {
        // При создании корректировки требуется, чтобы были заполнены ИЛИ adGroupId, ИЛИ campaignId, при получении
        // корректировки на группу оба поля заполнены
        if (bidModifier.getAdGroupId() != null) {
            bidModifier.setCampaignId(null);
        }
    }
}
