package ru.yandex.direct.core.copyentity.preprocessors

import org.springframework.stereotype.Component
import ru.yandex.direct.core.copyentity.CopyOperationContainer
import ru.yandex.direct.multitype.typesupport.TypeSupportUtils

/**
 * Препроцессор, обеспечивает предварительную обработку копируемых сущностей в зависимости от типа
 */
@Component
class CopyPreprocessorFacade(
    private val typeSupports: List<CopyPreprocessorTypeSupport<*>>,
) {
    fun <T> preprocess(entities: List<T>, copyContainer: CopyOperationContainer) {
        TypeSupportUtils.getObjectsByTypeSupports(typeSupports, entities) { it!!::class.java }
            .forEach { (typeSupport, entitiesForSupport) ->
                apply(typeSupport, entitiesForSupport, copyContainer)
            }
    }

    private fun <T, M : T> apply(
        typeSupport: CopyPreprocessorTypeSupport<M>,
        entities: List<T>,
        copyContainer: CopyOperationContainer,
    ) {
        @Suppress("UNCHECKED_CAST")
        val typedEntities = entities as List<M>
        typeSupport.preprocess(typedEntities, copyContainer)
    }
}
