package ru.yandex.direct.core.copyentity.preprocessors;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.copyentity.CopyOperationContainer;
import ru.yandex.direct.multitype.typesupport.TypeSupport;

/**
 * Осуществляет предобработку сущностей одного типа перед копированием
 *
 * @param <T> тип сущности для предобработки
 */
@ParametersAreNonnullByDefault
public interface CopyPreprocessorTypeSupport<T> extends TypeSupport<T> {
    default void preprocess(List<T> entities, CopyOperationContainer copyContainer) {
        entities.forEach(e -> preprocess(e, copyContainer));
    }

    void preprocess(T entity, CopyOperationContainer copyContainer);
}
