package ru.yandex.direct.core.copyentity.preprocessors

import org.springframework.stereotype.Component
import ru.yandex.direct.core.copyentity.CopyOperationContainer
import ru.yandex.direct.core.entity.currency.service.CurrencyConverterFactory
import ru.yandex.direct.core.entity.performancefilter.model.PerformanceFilter
import ru.yandex.direct.currency.Currencies

@Component
class PerformanceFilterCopyPreprocessor(
    private val currencyConverterFactory: CurrencyConverterFactory,
) : CopyPreprocessorTypeSupport<PerformanceFilter> {
    override fun getTypeClass() = PerformanceFilter::class.java

    override fun preprocess(entity: PerformanceFilter, copyContainer: CopyOperationContainer) {
        if (!copyContainer.flags.isCopyKeywordStatuses) {
            entity.isSuspended = false
        }

        if (copyContainer.clientFrom.workCurrency != copyContainer.clientTo.workCurrency) {
            val converter = currencyConverterFactory.createConverter(
                copyContainer.clientFrom.workCurrency,
                copyContainer.clientTo.workCurrency,
            )
            val currencyTo = Currencies.getCurrency(copyContainer.clientTo.workCurrency)

            entity.priceCpa = converter.convert(entity.priceCpa, currencyTo.minCpcCpaPerformance, currencyTo.maxPrice)
            entity.priceCpc = converter.convert(entity.priceCpc, currencyTo.minCpcCpaPerformance, currencyTo.maxPrice)
        }
    }
}
