package ru.yandex.direct.core.copyentity.preprocessors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.copyentity.CopyOperationContainer;
import ru.yandex.direct.core.entity.promoextension.model.PromoExtension;

@Component
@ParametersAreNonnullByDefault
public class PromoExtensionPreprocessor implements CopyPreprocessorTypeSupport<PromoExtension> {

    @Override
    public Class<PromoExtension> getTypeClass() {
        return PromoExtension.class;
    }

    @Override
    public void preprocess(PromoExtension entity, CopyOperationContainer copyContainer) {
        if (!copyContainer.isCopyingBetweenClients()) {
            return;
        }
        entity.setClientId(copyContainer.getClientIdTo());
    }
}
