package ru.yandex.direct.core.copyentity.preprocessors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.copyentity.CopyOperationContainer;
import ru.yandex.direct.core.entity.currency.service.CurrencyConverterFactory;
import ru.yandex.direct.core.entity.relevancematch.model.RelevanceMatch;
import ru.yandex.direct.currency.Currencies;
import ru.yandex.direct.currency.Currency;
import ru.yandex.direct.currency.CurrencyCode;

@Component
@ParametersAreNonnullByDefault
public class RelevanceMatchCopyPreprocessor implements CopyPreprocessorTypeSupport<RelevanceMatch> {
    private final CurrencyConverterFactory currencyConverterFactory;

    public RelevanceMatchCopyPreprocessor(CurrencyConverterFactory currencyConverterFactory) {
        this.currencyConverterFactory = currencyConverterFactory;
    }

    @Override
    public Class<RelevanceMatch> getTypeClass() {
        return RelevanceMatch.class;
    }

    @Override
    public void preprocess(RelevanceMatch entity, CopyOperationContainer copyContainer) {
        CurrencyCode currencyCodeFrom = copyContainer.getClientFrom().getWorkCurrency();
        CurrencyCode currencyCodeTo = copyContainer.getClientTo().getWorkCurrency();
        Currency currencyTo = Currencies.getCurrency(currencyCodeTo);

        if (currencyCodeFrom != currencyCodeTo) {
            // смена валюты возможна только при копировании кампании, то есть стратегия либо не меняется, либо
            // меняется на автобюджет, при которой задавать ставки по-умолчанию не нужно, поэтому просто
            // конвертируем те что есть.
            var converter = currencyConverterFactory.createConverter(currencyCodeFrom, currencyCodeTo);

            var minPrice = currencyTo.getMinPrice();
            var maxPrice = currencyTo.getMaxPrice();

            if (entity.getPrice() != null) {
                entity.setPrice(converter.convert(entity.getPrice(), minPrice, maxPrice));
            }

            if (entity.getPriceContext() != null) {
                entity.setPriceContext(converter.convert(entity.getPriceContext(), minPrice, maxPrice));
            }
        }
    }
}
