package ru.yandex.direct.core.copyentity.preprocessors.campaign

import org.springframework.stereotype.Component
import ru.yandex.direct.core.copyentity.CopyOperationContainer
import ru.yandex.direct.core.copyentity.preprocessors.CopyPreprocessorTypeSupport
import ru.yandex.direct.core.entity.campaign.model.CampaignWithAllowedPageIds
import ru.yandex.direct.core.entity.feature.service.FeatureService
import ru.yandex.direct.feature.FeatureName

@Component
class CampaignWithAllowedPageIdsCopyPreprocessor(
    private val featureService: FeatureService,
) : CopyPreprocessorTypeSupport<CampaignWithAllowedPageIds> {
    override fun getTypeClass() = CampaignWithAllowedPageIds::class.java

    override fun preprocess(entity: CampaignWithAllowedPageIds, copyContainer: CopyOperationContainer) {
        if (!featureService.isEnabledForUid(
                copyContainer.operatorUid,
                listOf(FeatureName.SET_CAMPAIGN_ALLOWED_PAGE_IDS)
            )
        ) {
            entity.allowedPageIds = null
            entity.allowedSsp = null
            entity.allowedDomains = null
        }
    }
}
