package ru.yandex.direct.core.copyentity.preprocessors.campaign

import org.springframework.stereotype.Component
import ru.yandex.direct.core.copyentity.CopyOperationContainer
import ru.yandex.direct.core.copyentity.preprocessors.CopyPreprocessorTypeSupport
import ru.yandex.direct.core.entity.bidmodifier.BidModifierGeo
import ru.yandex.direct.core.entity.campaign.model.CampaignWithBidModifiers

@Component
class CampaignWithBidModifiersCopyPreprocessor : CopyPreprocessorTypeSupport<CampaignWithBidModifiers> {
    override fun getTypeClass() = CampaignWithBidModifiers::class.java

    override fun preprocess(entity: CampaignWithBidModifiers, copyContainer: CopyOperationContainer) {
        entity.bidModifiers
            ?.filterIsInstance<BidModifierGeo>()
            ?.filter { it.regionalAdjustments != null }
            ?.onEach { filterHiddenRegionalAdjustments(it) }
    }

    /**
     * Hidden коэффициенты &mdash; технические, и должны создаваться в рамках операции добавления корректировок
     */
    private fun filterHiddenRegionalAdjustments(bidModifierGeo: BidModifierGeo) {
        bidModifierGeo.regionalAdjustments = bidModifierGeo.regionalAdjustments
            .filter { !it.hidden }
    }
}
