package ru.yandex.direct.core.copyentity.preprocessors.campaign

import org.springframework.stereotype.Component
import ru.yandex.direct.core.copyentity.CopyOperationContainer
import ru.yandex.direct.core.copyentity.preprocessors.CopyPreprocessorTypeSupport
import ru.yandex.direct.core.entity.campaign.model.CampaignWithBrandLift

@Component
class CampaignWithBrandLiftCopyPreprocessor : CopyPreprocessorTypeSupport<CampaignWithBrandLift> {
    override fun getTypeClass() = CampaignWithBrandLift::class.java

    override fun preprocess(campaign: CampaignWithBrandLift, copyContainer: CopyOperationContainer) {
        // Не копируем Brand Lift и его ab-сегменты (https://st.yandex-team.ru/DIRECT-153189),
        // и при межклиентском копировании тоже
        if (campaign.brandSurveyId != null || copyContainer.isCopyingBetweenClients) {
            campaign.abSegmentRetargetingConditionId = null
            campaign.abSegmentStatisticRetargetingConditionId = null
        }

        if (campaign.brandSurveyId != null) {
            campaign.sectionIds = null
            campaign.abSegmentGoalIds = null
        }

        campaign.brandSurveyId = null
    }
}
