package ru.yandex.direct.core.copyentity.preprocessors.campaign

import org.springframework.stereotype.Component
import ru.yandex.direct.core.copyentity.CopyOperationContainer
import ru.yandex.direct.core.copyentity.preprocessors.CopyPreprocessorTypeSupport
import ru.yandex.direct.core.entity.campaign.model.CampaignWithBrandSafety
import ru.yandex.direct.core.entity.crypta.utils.CryptaSegmentBrandSafetyUtils.checkIfBrandSafetyCategoryIsAvailableForClient
import ru.yandex.direct.core.entity.feature.service.FeatureService

@Component
class CampaignWithBrandSafetyCopyPreprocessor(
    private val featureService: FeatureService,
) : CopyPreprocessorTypeSupport<CampaignWithBrandSafety> {
    override fun getTypeClass() = CampaignWithBrandSafety::class.java

    override fun preprocess(entities: List<CampaignWithBrandSafety>, copyContainer: CopyOperationContainer) {
        if (!copyContainer.isCopyingBetweenClients) {
            return;
        }
        val clientFeatures = featureService.getEnabledForClientId(copyContainer.clientIdTo)
        
        for (entity in entities) {
            entity.brandSafetyRetCondId = null
            entity.brandSafetyCategories = entity.brandSafetyCategories.filter { brandSafetyCategory ->
                checkIfBrandSafetyCategoryIsAvailableForClient(
                    brandSafetyCategory,
                    clientFeatures
                )
            }
        }
    }

    override fun preprocess(entity: CampaignWithBrandSafety, copyContainer: CopyOperationContainer) {
        preprocess(listOf(entity), copyContainer)
    }
}
