package ru.yandex.direct.core.copyentity.preprocessors.campaign

import org.springframework.stereotype.Component
import ru.yandex.direct.core.copyentity.CopyOperationContainer
import ru.yandex.direct.core.copyentity.preprocessors.CopyPreprocessorTypeSupport
import ru.yandex.direct.core.entity.campaign.model.CampaignWithBroadMatch

@Component
class CampaignWithBroadMatchCopyPreprocessor : CopyPreprocessorTypeSupport<CampaignWithBroadMatch> {
    override fun getTypeClass() = CampaignWithBroadMatch::class.java

    override fun preprocess(entity: CampaignWithBroadMatch, copyContainer: CopyOperationContainer) {
        if (entity.broadMatch != null) {
            entity.broadMatch.broadMatchGoalId = 0
        }
    }
}
