package ru.yandex.direct.core.copyentity.preprocessors.campaign

import org.springframework.stereotype.Component
import ru.yandex.direct.core.copyentity.CopyOperationContainer
import ru.yandex.direct.core.copyentity.preprocessors.CopyPreprocessorTypeSupport
import ru.yandex.direct.core.entity.calltrackingsettings.repository.CalltrackingSettingsRepository
import ru.yandex.direct.core.entity.campaign.model.CampaignWithCalltrackingOnSite

@Component
class CampaignWithCalltrackingOnSiteCopyPreprocessor(
    private val calltrackingSettingsRepository: CalltrackingSettingsRepository,
) : CopyPreprocessorTypeSupport<CampaignWithCalltrackingOnSite> {
    override fun getTypeClass() = CampaignWithCalltrackingOnSite::class.java

    override fun preprocess(
        entities: List<CampaignWithCalltrackingOnSite>,
        copyContainer: CopyOperationContainer
    ) {
        if (!copyContainer.isCopyingBetweenClients) {
            return;
        }
        val domainIdsByCalltrackingSettingsIds = calltrackingSettingsRepository
            .getDomainIdsByCalltrackingSettingsIds(
                copyContainer.shardFrom,
                copyContainer.clientIdFrom,
                entities.mapNotNull { x -> x.calltrackingSettingsId })

        val calltrackingSettingsIdsByDomainIds = calltrackingSettingsRepository.getCalltrackingSettingsIdsByDomainIds(
            copyContainer.shardTo,
            copyContainer.clientIdTo,
            domainIdsByCalltrackingSettingsIds.values
        )

        for (entity in entities) {
            entity.calltrackingSettingsId = calltrackingSettingsIdsByDomainIds[domainIdsByCalltrackingSettingsIds[entity.calltrackingSettingsId]]
        }
    }

    override fun preprocess(entity: CampaignWithCalltrackingOnSite, copyContainer: CopyOperationContainer) {
        preprocess(listOf(entity), copyContainer)
    }
}
