package ru.yandex.direct.core.copyentity.preprocessors.campaign

import org.springframework.stereotype.Component
import ru.yandex.direct.core.copyentity.CopyOperationContainer
import ru.yandex.direct.core.copyentity.preprocessors.CopyPreprocessorTypeSupport
import ru.yandex.direct.core.entity.campaign.model.CampaignWithCustomCheckPositionEvent

@Component
class CampaignWithCustomCheckPositionEventCopyPreprocessor :
    CopyPreprocessorTypeSupport<CampaignWithCustomCheckPositionEvent> {
    override fun getTypeClass() = CampaignWithCustomCheckPositionEvent::class.java

    override fun preprocess(campaign: CampaignWithCustomCheckPositionEvent, copyContainer: CopyOperationContainer) {
        if (copyContainer.isCopyingBetweenClients && !copyContainer.flags.isCopyNotificationSettings) {
            // На поле enableCheckPositionEvent маппируется поле camp_options.sendWarn
            campaign.enableCheckPositionEvent = copyContainer.chiefUserTo.sendWarn
        }
    }
}
