package ru.yandex.direct.core.copyentity.preprocessors.campaign

import org.springframework.stereotype.Component
import ru.yandex.direct.core.copyentity.CopyOperationContainer
import ru.yandex.direct.core.copyentity.preprocessors.CopyPreprocessorTypeSupport
import ru.yandex.direct.core.entity.campaign.model.CampaignWithCustomStrategyAndCustomDayBudget
import ru.yandex.direct.core.entity.campaign.service.CampaignStrategyUtils.strategySupportsDayBudget
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithCustomStrategyAndCustomDayBudgetValidator
import java.math.BigDecimal

@Component
class CampaignWithCustomStrategyAndCustomDayBudgetCopyPreprocessor :
    CopyPreprocessorTypeSupport<CampaignWithCustomStrategyAndCustomDayBudget> {

    override fun getTypeClass() = CampaignWithCustomStrategyAndCustomDayBudget::class.java

    /**
     * Бюджет может быть задан мимо валидации в core, из-за чего кампанию не получится скопировать
     * @see CampaignWithCustomStrategyAndCustomDayBudgetValidator
     */
    override fun preprocess(
        entity: CampaignWithCustomStrategyAndCustomDayBudget,
        copyContainer: CopyOperationContainer,
    ) {
        if (!strategySupportsDayBudget(entity.strategy)) {
            entity.dayBudget = BigDecimal.ZERO
        }
    }
}
