package ru.yandex.direct.core.copyentity.preprocessors.campaign

import org.springframework.stereotype.Component
import ru.yandex.direct.core.copyentity.CopyOperationContainer
import ru.yandex.direct.core.copyentity.preprocessors.CopyPreprocessorTypeSupport
import ru.yandex.direct.core.entity.campaign.model.CampaignWithDayBudget
import ru.yandex.direct.core.entity.currency.service.CurrencyConverterFactory
import ru.yandex.direct.currency.Currencies

@Component
class CampaignWithDayBudgetCopyPreprocessor(
    private val currencyConverterFactory: CurrencyConverterFactory,
) : CopyPreprocessorTypeSupport<CampaignWithDayBudget> {
    override fun getTypeClass() = CampaignWithDayBudget::class.java

    override fun preprocess(entity: CampaignWithDayBudget, copyContainer: CopyOperationContainer) {
        if (copyContainer.clientFrom.workCurrency == copyContainer.clientTo.workCurrency) {
            return
        }

        val currencyTo = Currencies.getCurrency(copyContainer.clientTo.workCurrency)
        val converter = currencyConverterFactory.createConverter(
            copyContainer.clientFrom.workCurrency,
            copyContainer.clientTo.workCurrency
        )

        if (entity.dayBudget != null) {
            entity.dayBudget = converter.convert(
                entity.dayBudget,
                currencyTo.minDayBudget,
                currencyTo.maxDailyBudgetAmount
            )
        }
    }
}
