package ru.yandex.direct.core.copyentity.preprocessors.campaign

import org.springframework.stereotype.Component
import ru.yandex.direct.core.copyentity.CopyOperationContainer
import ru.yandex.direct.core.copyentity.preprocessors.CopyPreprocessorTypeSupport
import ru.yandex.direct.core.entity.campaign.model.CampaignWithDialog

@Component
class CampaignWithDialogCopyPreprocessor : CopyPreprocessorTypeSupport<CampaignWithDialog> {
    override fun getTypeClass() = CampaignWithDialog::class.java

    override fun preprocess(campaign: CampaignWithDialog, copyContainer: CopyOperationContainer) {
        if (copyContainer.isCopyingBetweenClients) {
            campaign.clientDialogId = null
        }
    }
}
