package ru.yandex.direct.core.copyentity.preprocessors.campaign

import org.springframework.stereotype.Component
import ru.yandex.direct.core.copyentity.CopyOperationContainer
import ru.yandex.direct.core.copyentity.preprocessors.CopyPreprocessorTypeSupport
import ru.yandex.direct.core.entity.campaign.model.CampaignWithDisabledDomainsAndSsp
import ru.yandex.direct.core.entity.campaign.service.type.add.CampaignWithDisabledDomainsAndSspAddOperationSupport
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstraints.checkDisabledPlacesMaxSize
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithDisabledDomainsAndSspValidator
import ru.yandex.direct.core.entity.client.model.ClientLimits
import ru.yandex.direct.core.entity.client.service.ClientLimitsService
import ru.yandex.direct.libs.mirrortools.utils.HostingsHandler

@Component
class CampaignWithDisabledDomainsAndSspCopyPreprocessor(
    private val hostingsHandler: HostingsHandler,
    private val clientLimitsService: ClientLimitsService
) : CopyPreprocessorTypeSupport<CampaignWithDisabledDomainsAndSsp> {
    override fun getTypeClass() = CampaignWithDisabledDomainsAndSsp::class.java

    override fun preprocess(
        entities: List<CampaignWithDisabledDomainsAndSsp>,
        copyContainer: CopyOperationContainer
    ) {
        val clientLimits: ClientLimits = clientLimitsService.getClientLimits(copyContainer.clientIdTo)
        val generalBlacklistSizeLimit = clientLimits.generalBlacklistSizeLimitOrDefault.toInt()
        for (entity in entities) {
            if (entity.disabledDomains != null) {
                entity.disabledDomains = entity.disabledDomains
                    .distinctBy { hostingsHandler.stripWww(it) }
            }

            if (!checkDisabledPlacesMaxSize(entity, generalBlacklistSizeLimit)) {
                entity.disabledDomains = null
                entity.disabledSsp = null
            }
        }
    }

    /**
     * Старые кампании могут иметь дубликаты среди доменов, уникализируем перед сохранением
     * @see CampaignWithDisabledDomainsAndSspAddOperationSupport
     * @see CampaignWithDisabledDomainsAndSspValidator
     */
    override fun preprocess(entity: CampaignWithDisabledDomainsAndSsp, copyContainer: CopyOperationContainer) {
        preprocess(listOf(entity), copyContainer);
    }
}
