package ru.yandex.direct.core.copyentity.preprocessors.campaign

import org.springframework.stereotype.Component
import ru.yandex.direct.core.copyentity.CopyOperationContainer
import ru.yandex.direct.core.copyentity.preprocessors.CopyPreprocessorTypeSupport
import ru.yandex.direct.core.entity.campaign.model.CampaignWithExperiments
import ru.yandex.direct.core.entity.feature.service.FeatureService
import ru.yandex.direct.feature.FeatureName

@Component
class CampaignWithExperimentsCopyPreprocessor(
    private val featureService: FeatureService,
) : CopyPreprocessorTypeSupport<CampaignWithExperiments> {
    override fun getTypeClass() = CampaignWithExperiments::class.java

    override fun preprocess(entity: CampaignWithExperiments, copyContainer: CopyOperationContainer) {
        // Костыль для поддержки обоих вариантов фичи: DIRECT-112091
        if (featureService.isEnabledForClientId(copyContainer.clientIdFrom,
                FeatureName.EXPERIMENT_RET_CONDITIONS_CREATING_ON_TEXT_CAMPAIGNS_MODIFY_IN_JAVA_FOR_DNA)) {
            entity.abSegmentRetargetingConditionId = null
            entity.abSegmentStatisticRetargetingConditionId = null
        } else {
            entity.sectionIds = null
            entity.abSegmentGoalIds = null
        }

        // Так же сбрасываем ссылки на retargeting_conditions при копировании между клиентами
        if (copyContainer.isCopyingBetweenClients) {
            entity.abSegmentRetargetingConditionId = null
            entity.abSegmentStatisticRetargetingConditionId = null
        }
    }
}
